<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:ns1="https://puesc.gov.pl/ZEFIR2/xsd/v1_0/VAT_IM.xsd" xmlns:ns2="http://www.w3.org/2000/09/xmldsig#" xmlns:ns3="https://puesc.gov.pl/ZEFIR2/xsd/v12_0/Types.xsd" xmlns:ns4="https://puesc.gov.pl/ZEFIR2/xsd/v12_0/Trader.xsd" xmlns:tp="https://puesc.gov.pl/ZEFIR2/xsd/v12_0/Types.xsd" xmlns:tr="https://puesc.gov.pl/ZEFIR2/xsd/v12_0/Trader.xsd" xmlns:im="http://www.e-clo.pl/ZEFIR2/eZefir2/xsd/v4_0/VAT_14.xsd" version="1.0">
	<xsl:decimal-format NaN="" decimal-separator="." grouping-separator=" "/>
	<xsl:output encoding="UTF-8" method="html"/>
	<xsl:template match="/">
		<xsl:apply-templates select="*"/>
	</xsl:template>
	<!-- POCZATEK ALL -->
	<!-- STYL ARKUSZA -->
	<xsl:template match="*" mode="styl1">
		<style type="text/css">body {margin:0;font-family:Verdana,Helvetica,sans-serif;font-size:10px;text-align:justify;}</style>
		<style type="text/css">*{font-family:Verdana,Helvetica,sans-serif;padding:3px;color:black;}</style>
		<style type="text/css">a{color:#3366FF;font-weight:bold;}</style>
		<style type="text/css">h3{padding:3px;cursor:help;}</style>
		<style type="text/css">h4,h5,.copyr{text-align:center;}</style>
		<style type="text/css">caption{font-weight:bold;}</style>
		<style type="text/css">table,div,td{font-size:8pt;border-color:black;}</style>
		<style type="text/css">table{border-top:1 solid;border-bottom:2 solid;border-left:1 solid;border-right:1 solid;}</style>
		<style type="text/css">th,td{border-top:1 solid;border-bottom:1 solid;border-left:1 solid;border-right:1 solid;}</style>
		<style type="text/css">#cont{display:none}</style>
		<style type="text/css">.copyr{background:#B1D8FF;font-weight:bold;}</style>
		<style type="text/css">.nag1 {font-size: 20px; font-weight: bold;}</style>
		<style type="text/css">.nag2{font-size: 20px}</style>
		<style type="text/css">.cz10 {font-size: 10px}</style>
		<style type="text/css">.cz12 {	font-size: 12px}</style>
		<style type="text/css">.cz18 {font-size: 18px}</style>
		<style type="text/css">.cz16 {font-size: 16px}</style>
		<style type="text/css">.cz14 {font-size: 14px}</style>
	</xsl:template>
	<!-- SZABLON STOPKI -->
	<xsl:template match="*" mode="stopka">
		<xsl:value-of select="name()"/>
	</xsl:template>
	<xsl:template match="*">
		<!-- ZASTOSOWANIE STYLU -->
		<xsl:apply-templates mode="styl1" select="*"/>
		<!-- DEKLARACJE AKCYZOWE -->
		<xsl:apply-templates mode="dekl_im" select="."/>
	</xsl:template>
	<!-- SZABLON DOT. DEKLARACJI AKCYZOWYCH -->
	<xsl:template match="*" mode="dekl_im">
		<xsl:for-each select=" ns1:Header |  ns4:* | im:Header | tr:* ">
			<!-- SZABLON DOT.  IDENTYFIKATORA PODATNIKA-->
			<xsl:apply-templates mode="Ident" select="."/>
			<!-- SZABLON DLA RODZAJU DEKLARACJI -->
			<xsl:apply-templates mode="rodz_dekl" select="."/>
			<!-- SZABLON DOT.  OKRESU ROK MIESIAC -->
			<xsl:apply-templates mode="rok_mc" select="."/>
			<!-- SZABLON DOT.  PODSTAWY PRAWNEJ DLA DEKLARACJI -->
			<xsl:apply-templates mode="PodstawaPrawna" select="."/>
			<!-- SZABLON DOT. MIEJSCE SKLADANIA DEKLARACJI -->
			<xsl:apply-templates mode="MiejsceDekl" select="."/>
			<!-- SZABLON DOT. DANYCH PODATNIKA -->
			<xsl:apply-templates mode="DanePodatnika" select="."/>
			<xsl:apply-templates mode="Adres" select="."/>
			<!-- SZABLON DOT. KWOTY PODATKU -->
			<xsl:apply-templates mode="RozliczenieImportu" select="."/>
			<xsl:apply-templates mode="NowaStrona_Zal" select="."/>
			<!-- SZABLON DOT. OSWIADCZENIE PODATNIKA LUB OSOBY REPREZENTUJACEJ -->
			<xsl:apply-templates mode="InformacjaZal" select="."/>
			<xsl:apply-templates mode="OswPodatnika" select="."/>
			<!-- SZABLON DOT. ADNOTACJI-->
			<!-- <xsl:apply-templates mode="Adnotacje" select="."/> -->
			<!-- SZABLON DOT. OBJASNIENIA I  POUCZENIA-->
			<xsl:apply-templates mode="ObjasnieniaAkc" select="."/>
			<xsl:apply-templates mode="Pouczenie" select="."/>
			<!-- SZABLON DOT. OBJASNIENIA I  POUCZENIA-->
			<!-- SZABLON DOT. WYROBOW -->
			<xsl:apply-templates mode="NowaStrona_Zal" select="."/>
			<!-- SZABLON DOT.  IDENTYFIKATORA PODATNIKA-->
			<xsl:apply-templates mode="Ident" select="."/>
			<!-- SZABLON DLA RODZAJU DEKLARACJI ZAŁĄCZNIK -->
			<xsl:apply-templates mode="rodz_dekl_zal" select="."/>
			<!-- SZABLON DOT.  OKRESU ROK MIESIAC ZAŁACZNIK-->
			<!-- <xsl:apply-templates mode="rok_mc_zal" select="."/> -->
			<!-- SZABLON DOT. DANYCH PODATNIKA -->
			<xsl:apply-templates mode="DanePodatnika_Zal" select="."/>
			<!-- SZABLON DOT. WYROBOW -->
			<xsl:apply-templates mode="Wyroby" select="."/>
		</xsl:for-each>
	</xsl:template>
	<!-- SZABLON DOT.  IDENTYFIKATORA PODATNIKA-->
	<xsl:template match="*" mode="Ident">
		<table border="1" width="955">
			<tr align="left" valign="top">
				<td align="left" colspan="2" height="45" valign="middle" width="586">
					<span class="cz12">
						<b>1. Identyfikator podatkowy NIP podatnika</b>
					</span>
				</td>
				<td align="center" colspan="2" valign="middle" width="353">
					<span class="nag2">
						<b>
							<xsl:value-of select="//@identifierNip"/>
							<xsl:value-of select="//@identifierEori"/>
							<xsl:value-of select="//@identifierPesel"/>
						</b>
					</span>
				</td>
			</tr>
			<tr align="left" colspan="1" valign="top">
				<td align="left" height="45" valign="top" width="353"/>
				<td align="left" bgcolor="#CCCCCC" colspan="2" height="45" valign="top">
					<b>2. Nr dokumentu</b>
					<br/>
					<span class="cz16">
						<b>
							<xsl:value-of select="@selfRef"/>
						</b>
					</span>
				</td>
				<td align="left" bgcolor="#CCCCCC" colspan="1" height="45" valign="top">
					<b>3. Status</b>
				</td>
			</tr>
		</table>
	</xsl:template>
	<!-- SZABLON DOT.  RODZAJU DEKLARACJI -->
	<xsl:template match="*" mode="rodz_dekl">
		<xsl:if test="ns1:* | im:*">
			<table border="1" width="956">
				<tr>
					<td colspan="3" height="40">
						<span class="nag1">VAT-IM</span>
					</td>
				</tr>
				<tr>
					<td>
						<div align="center">
							<span class="nag1">DEKLARACJA IMPORTOWA O PODATKU OD TOWARÓW I USŁUG</span>
							<span class="nag1"/>
						</div>
					</td>
				</tr>
			</table>
		</xsl:if>
	</xsl:template>
	<!-- SZABLON DOT.  OKRESU ROK MIESIAC -->
	<xsl:template match="*" mode="rok_mc">
		<table border="1" width="955">
			<tr>
				<td align="left" valign="top" width="227">
					<b>4. Numer zgłoszenia celnego<sup>1)</sup>
					</b>
					<br/>
					<div align="center" class="cz18">
						<xsl:value-of select="//@nrSAD"/>
					</div>
				</td>
				<td align="left" valign="top" width="220">
					<b>5. Data</b> (dzień-miesiąc-rok) <br/>
					<div align="center" class="cz18">
						<xsl:value-of select="substring(//@dateCustomsDeclaration,9,2)"/>
						<xsl:value-of select="substring(//@dateCustomsDeclaration,5,4)"/>
						<xsl:value-of select="substring(//@dateCustomsDeclaration,1,4)"/>
					</div>
				</td>
				<td align="center" valign="center" width="10">
					<b>za </b>
					<br/>
					<!--	<div align="center" class="cz18"> <xsl:value-of select="substring(//@period,1,4)"/> </div>-->
				</td>
				<td align="left" valign="top" width="226">
					<b>6.Miesiąc </b>
					<br/>
					<div align="center" class="cz18">
						<xsl:value-of select="substring(//@period,6,7)"/>
					</div>
				</td>
				<td align="left" valign="top">
					<b>6. Rok</b>
					<br/>
					<div align="center" class="cz18">
						<xsl:value-of select="substring(//@period,1,4)"/>
					</div>
				</td>
			</tr>
		</table>
	</xsl:template>
	<!-- SZABLON DOT.  PODSTAWY PRAWNEJ DLA DEKLARACJI -->
	<xsl:template match="*" mode="PodstawaPrawna">
		<xsl:if test="ns1:* | im:*">
			<table border="1" width="955">
				<tr bgcolor="#CCCCCC">
					<td align="left" valign="top" width="115">Podstawa prawna: </td>
					<td align="left" valign="top" width="824">Art. 33b ust. 1 ustawy z dnia 11 marca 2004 r. o podatku od towarów i usług (Dz. U. z 2020 r. poz. 106, z późn. zm.), zwanej dalej „ustawą”.</td>
				</tr>
				<tr bgcolor="#CCCCCC">
					<td align="left" valign="top">Składający:</td>
					<td align="left" valign="top">Podatnik, o którym mowa w art. 17 ust. 1 pkt 1 i 2 ustawy, stosujący odprawę scentrali zowaną, o której mowa w art. 179 rozporządzenia Parlamentu Europejskiego i Rady (UE) nr 952/2013 z dnia 9 października 2013 r. ustanawiającego unijnykodeks celny (Dz. Urz. UE L 269 z 10.10.2013, str. 1, z późn. zm.).</td>
				</tr>
				<tr bgcolor="#CCCCCC">
					<td align="left" valign="top">Termin składania:</td>
					<td align="left" valign="top">Deklarację importową składa się w terminie do 16. dnia miesiąca następującego po miesiącu, w którym powstał obowiązekpodatkowy z tytułu importu towarów, nie później jednak niż przed złożeniem deklaracji podatkowej za okres rozliczeniowy. </td>
				</tr>
				<tr bgcolor="#CCCCCC">
					<td align="left" valign="top">Miejsce składania: </td>
					<td align="left" valign="top">Urząd celno-skarbowy, przy pomocy którego wykonuje swoje zadania naczelnik urzędu celno-skarbowego, w którym towarypowinny być przedstawiane lub udostępniane do kontroli celnej.</td>
				</tr>
			</table>
		</xsl:if>
	</xsl:template>
	<!-- SZABLON DOT. MIEJSCE SKLADANIA DEKLARACJI -->
	<xsl:template match="*" mode="MiejsceDekl">
		<xsl:if test="ns1:* | im:*">
			<table border="1" width="955">
				<tr align="left" bgcolor="#CCCCCC" valign="top">
					<td colspan="3">
						<span class="nag1">A. MIEJSCE SKŁADANIA DEKLARACJI</span>
					</td>
				</tr>
				<tr align="left" valign="top">
					<td bgcolor="#CCCCCC" rowspan="4" width="46"/>
					<td colspan="2">
						<b>8. Urząd celno-skarbowy, do którego jest adresowana deklaracja</b>
						<br/>
						<span class="cz18">
							<xsl:value-of select="@taxOfficeName"/>
						</span>
					</td>
				</tr>
			</table>
		</xsl:if>
	</xsl:template>
	<!-- SZABLON DOT. DANYCH PODATNIKA -->
	<xsl:template match="*" mode="DanePodatnika">
		<xsl:if test="ns1:* | im:*">
			<table border="1" width="955">
				<tr bgcolor="#CCCCCC">
					<td colspan="5">
						<span class="nag1">B. DANE PODATNIKA</span>
						<br/> *- dotyczy podmiotów niebędących osobami fizycznymi     **- dotyczy podmiotów będących osobami fizycznymi </td>
				</tr>
				<tr bgcolor="#CCCCCC">
					<td colspan="4">
						<span class="nag2">B.1. DANE IDENTYFIKACYJNE</span>
					</td>
				</tr>
				<tr>
					<td bgcolor="#CCCCCC" rowspan="3" width="40"/>
					<td align="left" colspan="4" height="27" valign="top">
						<b>9. Rodzaj podatnika</b>(zaznaczyć właściwy kwadrat): </td>
				</tr>
				<tr>
					<xsl:if test=".//ns1:Trader/@typeOfTaxpayer='N'">
						<td align="left" valign="top" width="422">1. podatnik niebędący osobą fizyczną<br/>
							<span class="cz18"> ☑ </span>
						</td>
						<td align="left" valign="top" width="471">2. osoba fizyczna<br/>
							<span class="cz18"> ☐ </span>
						</td>
					</xsl:if>
					<xsl:if test=".//ns1:Trader/@typeOfTaxpayer='F'">
						<td align="left" valign="top" width="422">1. podatnik niebędący osobą fizyczną<br/>
							<span class="cz18"> ☐ </span>
						</td>
						<td align="left" valign="top" width="471">2. osoba fizyczna<br/>
							<span class="cz18"> ☑ </span>
							<br/>
						</td>
					</xsl:if>
				</tr>
				<tr>
					<td align="left" colspan="4" valign="top">
						<b>10. Nazwa pełna* / Nazwisko, pierwsze imię, data urodzenia **</b>
						<br/>
						<br/>
						<span class="cz18">
							<xsl:value-of select="//@fullName"/>
						</span>
						<!-- <span class="cz18"> <xsl:value-of select="//@REGON"/> </span> -->
						<span class="cz18">
							<xsl:value-of select="//@firstName"/>
						</span>
						<span class="cz18">
							<xsl:value-of select="//@surname"/>
						</span>
						<span class="cz18">
							<xsl:value-of select="//@dateOfBirth"/>
						</span>
						<span class="cz18">
							<xsl:value-of select="//@PESEL"/>
						</span>
					</td>
				</tr>
				<tr>
					<td width="40" bgcolor="#CCCCCC"> </td>
					<td colspan="4" align="left" valign="top">
						<b>11. Numer pozwolenia na stosowanie odprawy scentralizowanej</b>
						<br/>
						<br/>
						<span class="cz18"/>
					</td>
				</tr>
			</table>
		</xsl:if>
	</xsl:template>
	<!-- SZABLON DOT. ADRESU PODATNIKA -->
	<xsl:template match="*" mode="Adres">
		<xsl:if test="ns1:* | im:*">
			<table border="1" width="955">
				<tr bgcolor="#CCCCCC">
					<td colspan="6">
						<span class="nag2">B.2. ADRES SIEDZIBY<sup>*</sup>/ ADRES ZAMIESZKANIA<sup>**</sup>
						</span>
					</td>
				</tr>
				<tr align="left" valign="top">
					<td bgcolor="#CCCCCC" rowspan="3" width="40"/>
					<td width="269">
						<b>12. Kraj </b>
						<br/>
						<br/>
						<span class="cz18">
							<xsl:value-of select=".//@country"/>
						</span>
					</td>
					<td colspan="2">
						<b>13. Województwo</b>
						<br/>
						<br/>
						<span class="cz18">
							<xsl:value-of select=".//@provinceName"/>
						</span>
					</td>
					<td colspan="2">
						<b>14. Powiat</b>
						<br/>
						<br/>
						<span class="cz18">
							<xsl:value-of select=".//@districtName"/>
						</span>
					</td>
				</tr>
				<tr align="left" valign="top">
					<td>
						<b>15. Gmina </b>
						<br/>
						<br/>
						<span class="cz18">
							<xsl:value-of select=".//@communeName"/>
						</span>
					</td>
					<td colspan="2">
						<b>16. Ulica</b>
						<br/>
						<br/>
						<span class="cz18">
							<xsl:value-of select=".//@street"/>
						</span>
					</td>
					<td width="144">
						<b>17. Nr domu</b>
						<br/>
						<br/>
						<span class="cz18">
							<xsl:value-of select=".//@houseNumber"/>
						</span>
					</td>
					<td width="151">
						<b>18. Nr lokalu</b>
						<br/>
						<br/>
						<span class="cz18">
							<xsl:value-of select=".//@localNumber"/>
						</span>
					</td>
				</tr>
				<tr align="left" valign="top">
					<td>
						<b>19. Kod pocztowy </b>
						<br/>
						<br/>
						<span class="cz18">
							<xsl:value-of select=".//@postalCode"/>
						</span>
					</td>
					<td colspan="4">
						<b>20. Miejscowość </b>
						<br/>
						<br/>
						<span class="cz18">
							<xsl:value-of select=".//@city"/>
						</span>
					</td>
				</tr>
			</table>
			<!--	<table width="955"> <tr align="right" valign="top"> <td colspan="3"> <span class="nag1"> <xsl:apply-templates mode="stopka" select="../.."/> </span> <sub style="cz9">(6)</sub> <b style="nag1">/1</b> </td> </tr> </table> -->
		</xsl:if>
	</xsl:template>
	<!-- SZABLON DOT. KWOTY PODATKU -->
	<xsl:template match="ns1:Header | im:*" mode="RozliczenieImportu">
		<table border="1" width="955">
			<tr bgcolor="#CCCCCC">
				<td colspan="4">
					<span class="nag1">
						<b>C. ROZLICZENIE IMPORTU TOWARÓW</b>
					</span>
				</td>
			</tr>
			<tr>
				<td bgcolor="#CCCCCC" rowspan="6" width="50"/>
				<td align="center" bgcolor="#CCCCCC" valign="middle" width="80">
					<span class="cz14">
						<b> </b>
					</span>
				</td>
				<td align="center" bgcolor="#CCCCCC" valign="middle" width="250">
					<span class="cz12">
						<b>Podstawa opodatkowania w zł</b>
					</span>
				</td>
				<td align="center" bgcolor="#CCCCCC" valign="middle" width="250">
					<span class="cz12">
						<b>Podatek należny w zł</b>
					</span>
				</td>
			</tr>
			<tr>
				<td align="left" valign="top">
					<span class="cz10">
						<b>1. Import towarów opodatkowanych stawką 22% albo 23%</b>
					</span>
				</td>
				<td align="left" valign="top">
					<b>21.</b>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select="//@importOfGoods22_23_Basis"/>
					</div>
				</td>
				<td align="left" valign="top">
					<b>22.</b>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select="format-number(number(//@importOfGoods22_23_Tax),'# ##0')"/>
					</div>
				</td>
			</tr>
			<tr>
				<td align="left" valign="top">
					<span class="cz10">
						<b>2. Import towarów opodatkowanych stawką 7% albo 8%</b>
					</span>
				</td>
				<td align="left" valign="top">
					<b>23.</b>
					<br/>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select="//@importOfGoods7_8_Basis"/>
					</div>
				</td>
				<td align="left" valign="top">
					<b>24.</b>
					<br/>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select="format-number(number(//@importOfGoods7_8_Tax),'# ##0')"/>
					</div>
				</td>
			</tr>
			<tr>
				<td align="left" valign="top">
					<span class="cz10">
						<b>3. Import towarów opodatkowanych stawką 5%</b>
					</span>
				</td>
				<td align="left" valign="top">
					<b>25.</b>
					<br/>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select="//@importOfGoods5_Basis"/>
					</div>
				</td>
				<td align="left" valign="top">
					<b>26.</b>
					<br/>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select="format-number(number(//@importOfGoods5_Tax),'# ##0')"/>
					</div>
				</td>
			</tr>
			<tr>
				<td align="left" valign="top">
					<span class="cz10">
						<b>4. Import towarów opodatkowanych stawką 0%</b>
					</span>
				</td>
				<td align="left" valign="top">
					<b>27.</b>
					<br/>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select="//@importOfGoods0_Basis"/>
					</div>
				</td>
				<td bgcolor="#CCCCCC" align="left" valign="top">
					<b/>
					<br/>
					<div align="right" class="cz18" valign="top">   </div>
				</td>
			</tr>
			<tr>
				<td align="left" valign="top">
					<span class="cz10">
						<b>5. Import towarów zwolnionych od podatku</b>
					</span>
				</td>
				<td align="left" valign="top">
					<b>28.</b>
					<br/>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select="//@importOfGoods_Exemption"/>
					</div>
				</td>
				<td bgcolor="#CCCCCC" align="left" valign="top">
					<b/>
					<br/>
					<div align="right" class="cz18" valign="top">   </div>
				</td>
			</tr>
			<tr>
				<td bgcolor="#CCCCCC"/>
				<td align="left" bgcolor="#CCCCCC" colspan="2" valign="top">
					<b>Podatek podlegający wpłacie do naczelnika urzędu skarbowego w terminie do 16. dnia miesiąca następującego po miesiącu, w którym powstał obowiązek podatkowy z tytułu importu towarów, nie później niż przed złożeniem deklaracji podatkowej<sup>2)</sup>
					</b>
					<br/>
					<br/> Suma kwot z poz. 22, 24 i 26. </td>
				<td align="left" bordercolor="#000000" valign="top">
					<b>29.</b>
					<br/>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select="format-number(number(//@amountOfTax),'# ##0')"/>
					</div>
				</td>
			</tr>
		</table>
		<table width="955">
			<tr>
				<td>
					<p> 1) Należy wypełnić poz. 4 i 5, jeżeli podatnik składa deklarację dotyczącą zgłoszenia celnego, lub poz. 6 i 7, jeżeli składa deklarację zbiorczą za okres miesięczny, zgodnie z art. 33b ust. 2 ustawy.<br/> 2) Przez naczelnika urzędu skarbowego należy rozumieć naczelnika urzędu skarbowego właściwego do poboru kwoty należności celnychprzywozowych wynikających z długu celnego.  </p>
				</td>
			</tr>
			<tr align="right" valign="top">
				<td colspan="3">
					<span class="nag1">VAT-IM</span>
					<sub style="cz9">(6)</sub>
					<b style="nag1">/1</b>
				</td>
			</tr>
		</table>
	</xsl:template>
	<xsl:template match="*" mode="InformacjaZal">
		<xsl:if test="ns1:* | im:*">
			<table border="1" width="955">
				<tr align="left" bgcolor="#CCCCCC" valign="top">
					<td colspan="3">
						<span class="nag1">D. INFORMACJA O ZAŁĄCZNIKACH</span>
					</td>
				</tr>
				<tr align="left" valign="top">
					<td bgcolor="#CCCCCC" rowspan="4" width="46"/>
					<td colspan="2">
						<b>30. Należy podać liczbę dołączonych załączników VAT-IM/A</b>
						<br/>
						<div class="cz18" align="center" valign="center">
							<!-- <xsl:value-of select="@taxOfficeName"/> --> 1 </div>
					</td>
				</tr>
			</table>
		</xsl:if>
	</xsl:template>
	<!-- SZABLON DOT. OSWIADCZENIE PODATNIKA LUB OSOBY REPREZENTUJACEJ -->
	<xsl:template match="*" mode="OswPodatnika">
		<xsl:if test="ns1:* | ns3:* | im:* | tp:*">
			<table border="1" height="210" width="955">
				<tr align="left" bgcolor="#CCCCCC" valign="top">
					<td colspan="3">
						<b>
							<span class="nag1">E. PODPIS PODATNIKA LUB OSOBY REPREZENTUJĄCEJ PODATNIKA</span>
						</b>
						<br/>
					</td>
				</tr>
				<tr align="left" valign="top">
					<td bgcolor="#CCCCCC" rowspan="3" width="40"/>
					<td height="37" width="402">
						<b>31. Imię </b>
						<br/>
						<br/>
						<span class="cz18">
							<xsl:value-of select="//@repFirstName"/>
						</span>
					</td>
					<td width="491">
						<b> 32. Nazwisko </b>
						<br/>
						<br/>
						<span class="cz18">
							<xsl:value-of select="//@repSurname "/>
						</span>
					</td>
				</tr>
				<tr align="left" valign="top">
					<td height="39">
						<b>33. Telefon kontaktowy<sup>3)</sup>
						</b>
						<br/>
						<br/>
						<span class="cz18">
							<xsl:value-of select="ns1:Statement/ns3:representative/@phone"/>
						</span>
					</td>
					<td>
						<b>34. Data wypełnienia </b> (dzień-miesiąc-rok) 	<br/>
						<span class="cz18">
							<xsl:value-of select="substring(//@declarationDate,9,2)"/>
							<xsl:value-of select="substring(//@declarationDate,5,4)"/>
							<xsl:value-of select="substring(//@declarationDate,1,4)"/>
						</span>
					</td>
				</tr>
				<tr align="left" valign="top">
					<td colspan="2" height="70">
						<b>35. Podpis podatnika/płatnika lub osoby reprezentującej podatnika/płatnika </b>
						<br/>
						<br/>
						<span class="cz18">
							<xsl:value-of select="ns1:Statement/ns3:representative/@phone"/>, <xsl:value-of select="ns1:Statement/ns3:representative/@email"/>
						</span>
					</td>
				</tr>
			</table>
		</xsl:if>
	</xsl:template>
	<!-- SZABLON DOT. ADNOTACJI-->
	<xsl:template match="*" mode="Adnotacje">
		<xsl:if test="ns1:* | im:*">
			<table border="1" height="165" width="955">
				<tr bgcolor="#CCCCCC">
					<td class="nag1" colspan="3" height="36"> F. ADNOTACJE URZĘDU CELNEGO </td>
				</tr>
				<tr align="left" bgcolor="#CCCCCC" valign="top">
					<td rowspan="2" width="40"/>
					<td colspan="2" height="72">
						<b>36. Uwagi urzędu celno-skarbowego <br/>
							<br/>
							<br/>
							<br/>
							<br/>
							<br/>
							<br/>
						</b>
					</td>
				</tr>
				<tr align="left" bgcolor="#CCCCCC" valign="top">
					<td height="49" width="472">
						<b>37. Identyfikator przyjmującego formularz <br/>
							<br/>
							<br/>
						</b>
						<p/>
					</td>
					<td width="421">
						<b>38. Podpis przyjmującego formularz </b>
					</td>
				</tr>
			</table>
			<p>3) Pole nieobowiązkowe.</p>
			<br/>
			<br/>
		</xsl:if>
	</xsl:template>
	<!-- SZABLON DOT. OBJASNIENIA I  POUCZENIA-->
	<xsl:template match="*" mode="Pouczenie">
		<xsl:if test="ns1:* | im:*">
			<table width="955">
				<tr>
					<td>
						<p align="center">
							<b> Pouczenia </b>
						</p>
						<p>W przypadku niewpłacenia w obowiązującym terminie podatku z poz. 29 lub wpłacenia go w niepełnej wysokości, z zastrzeżeniem art. 33a ustawy, niniejsza deklaracja stanowi podstawę do wystawienia tytułu wykonawczego zgodnie z art. 3a § 1 pkt 1 ustawy z dnia 17 czerwca 1966 r. o postępowaniu egzekucyjnym w administracji  (Dz. U. z 2019 r. poz. 1438, z późn. zm.).<p>W przypadku niewpłacenia w obowiązującym terminie podatku z poz. 29 lub wpłacenia go w niepełnej wysokości, z zastrzeżeniem art. 33a ustawy, niniejsza deklaracja stanowi podstawę do wystawienia tytułu wykonawczego zgodnie z art. 3a § 1 pkt 1 ustawy z dnia 17 czerwca 1966 r. o postępowaniu egzekucyjnym w administracji  (Dz. U. z 2019 r. poz. 1438, z późn. zm.).</p>
						</p>
					</td>
				</tr>
				<tr align="right" valign="top">
					<td colspan="3">
						<span class="nag1">VAT-IM</span>
						<sub style="cz9">(6)</sub>
						<b style="nag1">/2</b>
					</td>
				</tr>
			</table>
		</xsl:if>
	</xsl:template>
	<!-- SZABLON DOT. OBJASNIENIA I  POUCZENIA-->
	<xsl:template match="*" mode="ObjasnieniaAkc">
		<xsl:if test="ns1:* | im:*">
			<table width="955">
				<tr>
					<td>
						<p align="center">
							<b>Objaśnienia</b>
							<b/>
						</p>
						<p> 1. Deklarację importową wypełnia się łącznie z załącznikiem, który stanowi szczegółową informację na temat dokonanego importu rozliczanego w tej deklaracji.<br/> 2. Deklaracja importowa składana jest przez podatników posiadających i stosujących pozwolenie na stosowanie odprawy scentralizowanej w odniesieniu do składanego zgłoszenia celnego. W przypadku gdy towary powinny być przedstawiane lub udostępniane do kontroli tylko w jednym urzędzie celno-skarbowym, podatnik może złożyć deklarację importową zbiorczą za okres miesięczny.<br/> 3. W poz. 8 należy podać pełną nazwę urzędu celno-skarbowego wraz z jego adresem.<br/> 4. W poz. 21-29 wszystkie wielkości wykazuje się zaokrąglone do pełnych złotych w ten sposób, że końcówki kwot wynoszące mniej niż 50 groszy pomija się, a końcówki kwot wynoszące 50 i więcej groszy podwyższa się do pełnych złotych.<br/> 5. W wierszu 1. „Import towarów opodatkowanych stawką 22% albo 23%” w poz. 21 wykazuje się podstawę opodatkowania importu towarów stawką w wysokości 22% lub w okresie wskazanym w art. 146aa ust. 1 pkt 1 ustawy stawką w wysokości 23%, a w poz. 22 podatek należny od tych czynności.<br/> 6. W wierszu 2. „Import towarów opodatkowanych stawką 7% albo 8%” w poz. 23 wykazuje się podstawę opodatkowania importu towarów stawką w wysokości 7% lub w okresie wskazanym w art. 146aa ust. 1 pkt 2 ustawy stawką w wysokości 8%, a w poz. 24 podatek należny od tych czynności. </p>
					</td>
				</tr>
			</table>
		</xsl:if>
	</xsl:template>
	<!-- SZABLON DOT.  RODZAJU DEKLARACJI -->
	<xsl:template match="*" mode="rodz_dekl_zal">
		<xsl:if test="ns1:* | im:*">
			<table border="1" width="956">
				<tr>
					<td colspan="3" height="40">
						<span class="nag1">VAT-IM/A</span>
					</td>
				</tr>
				<tr>
					<td>
						<div align="center">
							<span class="nag1">INFORMACJA O DOKONANYM IMPORCIE TOWARÓW</span>
							<br/>
							<span class="nag1"/>
						</div>
					</td>
				</tr>
			</table>
		</xsl:if>
	</xsl:template>
	<!-- SZABLON DOT.  OKRESU ROK MIESIAC -->
	<xsl:template match="*" mode="rok_mc_zal">
		<table border="1" width="955">
			<tr>
				<td height="49" width="227"/>
				<td align="left" valign="top" width="135">
					<b>2. Miesiac</b>
					<br/>
					<div align="center" class="cz18">
						<xsl:value-of select="substring(//@period,6,7)"/>
					</div>
				</td>
				<td align="left" valign="top" width="131">
					<b>3. Rok </b>
					<br/>
					<div align="center" class="cz18">
						<xsl:value-of select="substring(//@period,1,4)"/>
					</div>
				</td>
				<td width="226"/>
				<!--<td align="left" valign="top" width="226"> <b>4. Nr załącznika</b> <br/> <div align="center" class="cz18"> <xsl:value-of select=".//@formNo"/> </div> </td> -->
			</tr>
		</table>
	</xsl:template>
	<!-- SZABLON DOT. DANYCH PODATNIKA -->
	<xsl:template match="*" mode="DanePodatnika_Zal">
		<xsl:if test="ns1:* | im:*">
			<table width="955">
				<tr bgcolor="#CCCCCC">
					<td>
						<span class="cz12">Formularz składany jest jako załącznik do deklaracji importowej VAT-IM</span>
					</td>
				</tr>
			</table>
			<table border="1" width="955">
				<tr bgcolor="#CCCCCC">
					<td colspan="5">
						<span class="nag1">A. DANE IDENTYFIKACYJNE PODATNIKA</span>
						<br/> *- dotyczy podmiotów niebędących osobami fizycznymi     **- dotyczy podmiotów będących osobami fizycznymi </td>
				</tr>
				<tr>
					<td bgcolor="#CCCCCC" rowspan="3" width="40"/>
					<td align="left" colspan="4" height="27" valign="top">
						<b>5. Rodzaj podatnika</b>(zaznaczyć właściwy kwadrat): </td>
				</tr>
				<tr>
					<xsl:if test=".//ns1:Trader/@typeOfTaxpayer='N'">
						<td align="left" valign="top" width="422">1. podatnik niebędący osobą fizyczną<br/>
							<span class="cz18"> ☑ </span>
						</td>
						<td align="left" valign="top" width="471">2. osoba fizyczna<br/>
							<span class="cz18"> ☐ </span>
						</td>
					</xsl:if>
					<xsl:if test=".//ns1:Trader/@typeOfTaxpayer='F'">
						<td align="left" valign="top" width="422">1. podatnik niebędący osobą fizyczną<br/>
							<span class="cz18"> ☐ </span>
						</td>
						<td align="left" valign="top" width="471">2. osoba fizyczna<br/>
							<span class="cz18"> ☑ </span>
							<br/>
						</td>
					</xsl:if>
				</tr>
				<tr>
					<td align="left" colspan="4" valign="top">
						<b>6. Nazwa pełna* / Nazwisko, pierwsze imię, data urodzenia **</b>
						<br/>
						<br/>
						<span class="cz18">
							<xsl:value-of select="//@fullName"/>
						</span>
						<!-- <span class="cz18"> <xsl:value-of select="//@REGON"/> </span> -->
						<span class="cz18">
							<xsl:value-of select="//@firstName"/>
						</span>
						<span class="cz18">
							<xsl:value-of select="//@surname"/>
						</span>
						<span class="cz18">
							<xsl:value-of select="//@dateOfBirth"/>
						</span>
						<span class="cz18">
							<xsl:value-of select="//@PESEL"/>
						</span>
					</td>
				</tr>
			</table>
		</xsl:if>
	</xsl:template>
	<!-- SZABLON LAMANIA STRONY PRZED KAZDYM ZALACZNIKIEM -->
	<xsl:template match="*" mode="NowaStrona_Zal">
		<!-- tymczasowo -->
		<!-- ZNAK KONCA STRONY DO WYDRUKU -->
		<div style="page-break-before: always">
			<!-- <table width="955" border="1"> <tr align="right" valign="top"> <td colspan="3"> <span class="nag1"><b><xsl:apply-templates select="." mode = "stopka"/></b></span> </td> </tr> </table> -->
		</div>
	</xsl:template>
	<!-- SZABLON DOT. WYROBOW -->
	<xsl:template match="ns1:* | im:*" mode="Wyroby">
		<table border="1" width="955">
			<tr align="left" bgcolor="#CCCCCC" valign="top">
				<td class="nag1" colspan="11">B. INFORMACJA O DOKONANYM IMPORCIE TOWARÓW</td>
			</tr>
			<tr align="center" bgcolor="#CCCCCC" valign="middle">
				<td>Lp.</td>
				<td>Rodzaj towaru</td>
				<td>Numer zgłoszenia celnego </td>
				<td>Kod CN</td>
				<td>Ilość</td>
				<td>Wartość celna </td>
				<td>Należne cło</td>
				<td>Pozostałe elementy zwiększające podstawę opodatkowania importu</td>
				<td>Podstawa opodatkowania podatkiem od towarów i usług</td>
				<td>Stawka podatku</td>
				<td>Należny podatek</td>
			</tr>
			<tr align="left" bgcolor="#CCCCCC" valign="top">
				<td>
					<div align="center"/>
				</td>
				<td>
					<div align="center">a</div>
				</td>
				<td>
					<div align="center">b</div>
				</td>
				<td>
					<div align="center">c</div>
				</td>
				<td>
					<div align="center">d</div>
				</td>
				<td>
					<div align="center">e</div>
				</td>
				<td>
					<div align="center">f</div>
				</td>
				<td>
					<div align="center">g</div>
				</td>
				<td>
					<div align="center">h</div>
				</td>
				<td>
					<div align="center">i</div>
				</td>
				<td>
					<div align="center">j</div>
				</td>
			</tr>
			<xsl:for-each select="//ns1:Item | //im:Item">
				<tr align="left" valign="top">
					<td>
						<div align="right" class="cz12" valign="top">
							<xsl:value-of select="@id"/>
						</div>
					</td>
					<td>
						<div align="left" class="cz12" valign="top">
							<xsl:value-of select="@typeOfGoods"/>
						</div>
					</td>
					<td>
						<div align="right" class="cz12" valign="top">
							<xsl:value-of select="@nrAplicationSAD"/>
						</div>
					</td>
					<td>
						<div align="right" class="cz12" valign="top">
							<xsl:value-of select="@codeCN"/>
						</div>
					</td>
					<td>
						<div align="right" class="cz12" valign="top">
							<xsl:value-of select="@amount"/>
						</div>
					</td>
					<td>
						<div align="left" class="cz12" valign="top">
							<xsl:value-of select="@customsValue"/>
						</div>
					</td>
					<td>
						<div align="right" class="cz12" valign="top">
							<xsl:value-of select="@duties"/>
						</div>
					</td>
					<td>
						<div align="right" class="cz12" valign="top">
							<xsl:value-of select="@otherElements"/>
						</div>
					</td>
					<td>
						<div align="right" class="cz12" valign="top">
							<xsl:value-of select="@taxBase"/>
						</div>
					</td>
					<td>
						<div align="right" class="cz12" valign="top">
							<xsl:value-of select="@taxRate"/>
						</div>
					</td>
					<td>
						<div align="right" class="cz12" valign="top">
							<xsl:value-of select="@taxDue"/>
						</div>
					</td>
				</tr>
			</xsl:for-each>
		</table>
		<table width="955">
			<tr align="right" valign="top">
				<td colspan="3">
					<span class="nag1">VAT-IM/A</span>
					<sub style="cz9">(3)</sub>
					<b style="nag1">/1</b>
				</td>
			</tr>
		</table>
	</xsl:template>
	<!-- KONIEC all AG-->
</xsl:stylesheet>